import React, {useCallback} from 'react';

import {IBusesFilledContext} from 'types/buses/common/IBusesContext';
import {IFilledContextPoint} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';
import {IWithClassName} from 'types/withClassName';
import {EBusesGoal} from 'utilities/metrika/types/goals/buses';

import getCrumbs from 'projects/buses/pages/search/components/Footer/components/FooterBreadcrumbs/utilities/getCrumbs';
import {reachGoal} from 'utilities/metrika';

import LinkBreadcrumbs from 'components/LinkBreadcrumbs/LinkBreadcrumbs';

import cx from './FooterBreadcrumbs.scss';

interface IFooterBreadcrumbsProps extends IWithClassName {
    context?: IBusesFilledContext;
    city?: IFilledContextPoint;
    showDateItem: boolean;
    nonce: string;
}

const FooterBreadcrumbs: React.FC<IFooterBreadcrumbsProps> = props => {
    const {context, showDateItem, nonce, city, className} = props;

    const crumbs = getCrumbs(context, showDateItem, city);

    const handleClick = useCallback(() => {
        reachGoal(EBusesGoal.SEARCH_BREADCRUMBS_CLICK);
    }, []);

    return (
        <LinkBreadcrumbs
            className={cx('root', className)}
            scrollableClassName={cx('scrollable')}
            nonce={nonce}
        >
            {crumbs.map((crumb, index, array) => (
                <LinkBreadcrumbs.Item
                    key={crumb.url}
                    metaUrl={crumb.metaUrl}
                    title={crumb.title}
                    to={
                        index === array.length - 1
                            ? undefined
                            : {
                                  pathname: crumb.url,
                                  state: {
                                      scrollTop: 0,
                                  },
                              }
                    }
                    onClick={
                        index === array.length - 1 ? undefined : handleClick
                    }
                >
                    {crumb.name}
                </LinkBreadcrumbs.Item>
            ))}
        </LinkBreadcrumbs>
    );
};

export default React.memo(FooterBreadcrumbs);
