import React, {useCallback} from 'react';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {EBusesGoal} from 'utilities/metrika/types/goals/buses';
import {IBusesFilledContext} from 'types/buses/common/IBusesContext';
import {IBusesMapPoints} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {reachGoal} from 'utilities/metrika';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {getBookUrlFromContextAndSegment} from 'projects/buses/pages/search/components/Segments/components/Segment/utilities/getBookUrlFromContextAndSegment';

import * as i18nCommonBlock from 'i18n/common';
import * as i18nPluralBlock from 'i18n/common-plural';

import useCommonSegmentInfo from 'projects/buses/pages/search/components/Segments/components/Segment/hooks/useCommonSegmentInfo';
import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import LoadingBookingInfoOverlay from 'projects/buses/pages/search/components/Segments/components/Segment/components/LoadingBookingInfoOverlay/LoadingBookingInfoOverlay';
import CommonSegment from 'projects/buses/components/Segment/Segment';

import cx from './Segment.scss';

interface ISegmentProps extends IWithQaAttributes {
    segment: IBusesSegment;
    isHidden: boolean;
    isLoadingBookingInfo: boolean;
    context?: IBusesFilledContext | null;
    setMapPoints(points: IBusesMapPoints): void;
    when?: string;
}

const Segment: React.FC<ISegmentProps> = props => {
    const {
        setMapPoints,
        segment,
        isHidden,
        isLoadingBookingInfo,
        context,
        when,
    } = props;

    const deviceType = useDeviceType();
    const {freeSeats} = segment;

    const handleBookClick = useCallback(() => {
        reachGoal(EBusesGoal.SEARCH_SEGMENT_CHOOSE_PLACE);
    }, []);

    const commonSegmentInfo = useCommonSegmentInfo({
        segment,
        bookUrl: getBookUrlFromContextAndSegment(context, segment, when),
        freeSeatsInfo:
            freeSeats === -1
                ? i18nCommonBlock.withPlaces()
                : i18nPluralBlock.places({count: freeSeats}),
        setMapPoints,
        handleBookClick,
    });

    return (
        <CardWithDeviceLayout
            className={cx('root', {
                root_hidden: isHidden,
            })}
            paddingBottom={deviceType.isMobile ? 3 : undefined}
            {...prepareQaAttributes(props)}
        >
            <CommonSegment
                {...commonSegmentInfo}
                {...prepareQaAttributes(props)}
            />

            {isLoadingBookingInfo && <LoadingBookingInfoOverlay />}
        </CardWithDeviceLayout>
    );
};

export default React.memo(Segment);
