import {IBusesFilledContext} from 'types/buses/common/IBusesContext';
import {IBusesSegment} from 'types/buses/search/IBusesSegment';

import {busesURLs} from 'projects/buses/utilities/urls';

export function getBookUrlFromContextAndSegment(
    context: IBusesFilledContext | null | undefined,
    segment: IBusesSegment,
    when?: string,
): string {
    // TODO: проверить, что при генерации ссылки должен быть уже context
    if (!context || !when) {
        return '';
    }

    return busesURLs.getBookUrl({
        rideId: segment.id,
        from: context.from.slug,
        to: context.to.slug,
        when: when,
        placesCount: '1',
    });
}
