import {TBusesPoint} from 'types/buses/search/IBusesSegment';
import {IBusesMapPoint} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

import isPointWithCoordinates from 'projects/buses/pages/search/components/Segments/components/Segment/utilities/isPointWithCoordinates';

// TODO: почти 1 к 1 повторяет src/projects/buses/components/OrderSegment/hooks/useCommonSegmentProps/utilities/getMapPoint.ts
export default function getMapPoint(
    point: TBusesPoint,
): IBusesMapPoint | undefined {
    if (!isPointWithCoordinates(point)) {
        return undefined;
    }

    return {
        title: point.title,
        text: point.description,
        coordinates: {
            lat: point.coordinates.latitude,
            lon: point.coordinates.longitude,
        },
    };
}
