import {
    TBusesPoint,
    IBusesGeoPointWithCoordinates,
} from 'types/buses/search/IBusesSegment';

export default function isPointWithCoordinates(
    station: TBusesPoint,
): station is IBusesGeoPointWithCoordinates {
    return (
        'coordinates' in station &&
        Boolean(station.coordinates?.latitude) &&
        Boolean(station.coordinates?.longitude)
    );
}
