import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import SegmentMobileSkeleton from 'projects/buses/pages/search/components/Segments/components/SegmentSkeleton/components/SegmentMobileSkeleton/SegmentMobileSkeleton';
import SegmentDesktopSkeleton from 'projects/buses/pages/search/components/Segments/components/SegmentSkeleton/components/SegmentDesktopSkeleton/SegmentDesktopSkeleton';

import cx from './SegmentSkeleton.scss';

interface ISegmentSkeletonProps extends IWithQaAttributes {}

const SegmentSkeleton: React.FC<ISegmentSkeletonProps> = props => {
    const deviceType = useDeviceType();

    const skeleton = deviceType.isMobile ? (
        <SegmentMobileSkeleton />
    ) : (
        <SegmentDesktopSkeleton />
    );

    return (
        <div className={cx('root')} {...prepareQaAttributes(props)}>
            {skeleton}
        </div>
    );
};

export default React.memo(SegmentSkeleton);
