import React from 'react';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Box from 'components/Box/Box';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './SegmentDesktopSkeleton.scss';

const SegmentDesktopSkeleton: React.FC = () => {
    return (
        <CardWithDeviceLayout className={cx('root')}>
            <div className={cx('pointInfo')}>
                <TextSkeleton className={cx('time')} size="xl" />
                <TextSkeleton className={cx('stationFirstRow')} size="s" />
                <TextSkeleton className={cx('stationSecondRow')} size="s" />
            </div>

            <div className={cx('pointInfo')}>
                <TextSkeleton className={cx('time')} size="xl" />
                <TextSkeleton className={cx('stationFirstRow')} size="s" />
                <TextSkeleton className={cx('stationSecondRow')} size="s" />
            </div>

            <Box className={cx('additionalInfo')} between={1}>
                <TextSkeleton className={cx('duration')} size="m" />
                <TextSkeleton className={cx('carrier')} size="m" />
            </Box>
        </CardWithDeviceLayout>
    );
};

export default React.memo(SegmentDesktopSkeleton);
