import React from 'react';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Separator from 'components/Separator/Separator';
import Box from 'components/Box/Box';

import cx from './SegmentMobileSkeleton.scss';

const SegmentMobileSkeleton: React.FC = () => {
    return (
        <CardWithDeviceLayout className={cx('root')}>
            <Flex alignItems="flex-end">
                <Flex className={cx('departure')} flexDirection="column">
                    <TextSkeleton className={cx('date')} size="xxs" />
                    <TextSkeleton className={cx('time')} size="l" />
                </Flex>

                <Flex
                    className={cx('durationWithSeparators')}
                    alignItems="center"
                    x={2}
                >
                    <Separator className={cx('separator')} />
                    <TextSkeleton className={cx('duration')} size="s" />
                    <Separator className={cx('separator')} />
                </Flex>

                <Flex
                    className={cx('arrival')}
                    flexDirection="column"
                    alignItems="flex-end"
                >
                    <TextSkeleton className={cx('date')} size="xxs" />
                    <TextSkeleton className={cx('time')} size="l" />
                </Flex>
            </Flex>

            <Box above={1}>
                <TextSkeleton size="s" />
                <TextSkeleton className={cx('carrier')} size="s" />
            </Box>
        </CardWithDeviceLayout>
    );
};

export default React.memo(SegmentMobileSkeleton);
