import {Request} from '@yandex-data-ui/core/lib/types';
import {TBusesGetCalendarApiResponse} from 'server/api/BusesApi/types/TBusesGetCalendarApiResponse';

import {buses as busesProvider} from 'serviceProvider/buses/buses';

export default async function requestCalendar({
    req,
    fromPointKey,
    toPointKey,
    minDate,
    maxDate,
}: {
    req?: Request;
    fromPointKey: string;
    toPointKey: string;
    minDate?: string;
    maxDate: string;
}): Promise<TBusesGetCalendarApiResponse> {
    return busesProvider.provider(req?.container).getCalendar({
        fromPointKey,
        toPointKey,
        minDate,
        maxDate,
    });
}
