import {ETransport} from 'types/common/ETransport';
import {IBusesApiContext} from 'types/buses/common/IBusesContext';
import {Request} from '@yandex-data-ui/core/lib/types';

import {rasp as raspProvider} from 'serviceProvider/rasp/rasp';

export interface IBusesRequestContextParams {
    fromKey?: string;
    fromSlug?: string;
    toKey?: string;
    toSlug?: string;
}

export default async function requestContext({
    req,
    params,
}: {
    req?: Request;
    params: IBusesRequestContextParams;
}): Promise<IBusesApiContext> {
    return raspProvider.provider(req?.container).parseContext({
        from_key: params.fromKey,
        from_slug: params.fromSlug,
        to_key: params.toKey,
        to_slug: params.toSlug,
        transport: ETransport.BUS,
    });
}
