import {IBusesApiSegment} from 'server/api/BusesApi/types/IBusesGetSegmentsApiResponse';
import {IBusesGeoPoint} from 'types/buses/search/IBusesGeoPoint';
import {Request} from '@yandex-data-ui/core/lib/types';

import {buses as busesProvider} from 'serviceProvider/buses/buses';

/**
 * Загружает информацию о точках отправления/прибытия (поулярное название, координаты и т.д.)
 */
export default async function requestGeoPoints({
    req,
    segments,
}: {
    req?: Request;
    segments: IBusesApiSegment[];
}): Promise<IBusesGeoPoint[]> {
    const pointsIdsSet = new Set<string>();

    segments.forEach(({from, to}) => {
        if (from.id) {
            pointsIdsSet.add(`s${from.id}`);
        }

        if (to.id) {
            pointsIdsSet.add(`s${to.id}`);
        }
    });

    if (!pointsIdsSet.size) {
        return [];
    }

    const {data: points} = await busesProvider
        .provider(req?.container)
        .getGeoPoints({
            pointsIds: [...pointsIdsSet],
        });

    return points;
}
