import {Request} from '@yandex-data-ui/core/lib/types';
import {TBusesServicePopularDirections} from 'server/services/BusesService/types/IBusesGetPopularDirectionsServiceResponse';

import {buses as busesProvider} from 'serviceProvider/buses/buses';

export default async function requestPopularDirections({
    req,
    fromId,
    limit,
}: {
    req?: Request;
    fromId: string;
    limit: number;
}): Promise<TBusesServicePopularDirections> {
    const {directions} = await busesProvider
        .provider(req && req.container)
        .getPopularDirections({
            fromId,
            limit,
        });

    return directions;
}
