import {Request} from '@yandex-data-ui/core/lib/types';
import {IBusesOldRide} from 'types/buses/booking/IBusesOldRide';
import {EBusesSearchBookingInfoStatus} from 'reducers/buses/types/search/IBusesSearchBookingInfoStore';

import {buses as busesProvider} from 'serviceProvider/buses/buses';

export default async function requestRide({
    req,
    id,
    testStatus,
}: {
    req?: Request;
    id: string;
    testStatus?: EBusesSearchBookingInfoStatus;
}): Promise<IBusesOldRide> {
    return await busesProvider.provider(req?.container).getRide({
        'ride-id': id,
        testStatus,
    });
}
