import {Request} from '@yandex-data-ui/core/lib/types';
import {IBusesGetSuggestsServiceResponse} from 'server/services/BusesService/types/IBusesGetSuggestsServiceResponse';

import {buses as busesProvider} from 'serviceProvider/buses/buses';

export default async function requestSearchSuggests({
    req,
    part,
    clientCity,
    otherPoint,
}: {
    req?: Request;
    part: string;
    clientCity: string;
    otherPoint: string;
}): Promise<IBusesGetSuggestsServiceResponse> {
    return await busesProvider.provider(req?.container).getSuggests({
        part,
        client_city: clientCity,
        other_point: otherPoint,
        limit: 5,
    });
}
