import {EBusesTicketType} from 'types/buses/booking/IBusesBookParams';

import * as i18n from 'i18n/buses-BookPage-Cart';

export default function getTicketTypeName(
    ticketType: EBusesTicketType,
): string {
    switch (ticketType) {
        case EBusesTicketType.FULL: {
            return i18n.ticketTariffFull();
        }

        case EBusesTicketType.CHILD: {
            return i18n.ticketTariffChild();
        }

        case EBusesTicketType.BAGGAGE: {
            return i18n.ticketTariffBaggage();
        }
    }
}
