import {
    EBusesCalendar,
    TBusesCalendar,
} from 'types/buses/search/TBusesCalendar';

export default function getEarliestCalendarDateWithSegments(
    calendar: TBusesCalendar,
): string | null {
    return (
        Object.entries(calendar).find(
            ([_, {type, rideCount}]) =>
                type === EBusesCalendar.VALID && rideCount > 0,
        )?.[0] || null
    );
}
