import {IFilledContextPoint} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';
import {
    EBusesSuggestType,
    IBusesSuggest,
} from 'types/buses/common/IBusesSuggest';

import {isCity} from 'utilities/geo/geoObjectType';

/**
 * Преобразует данные точки отправления/прибытия из поискового контекста к виду поисковой формы
 *
 * @param point - пункт прибытия/отправления
 */
export const getPointData = (point: IFilledContextPoint): IBusesSuggest => {
    return {
        slug: point.slug,
        title: point.title,
        fullTitle: point.title,
        region: point.region.title,
        settlement: point.settlement.title,
        country: point.country.title,
        popularTitle: point.popularTitle || '',
        objType: isCity(point.key)
            ? EBusesSuggestType.SETTLEMENT
            : EBusesSuggestType.STATION,
        objId: point.key,
        pointKey: point.key,
        stationType: '',
        isUniqueTitle: true,
    };
};
