import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {IInternalUrlOptions} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

/**
 * Возвращает урл страницы города.
 */
export default function getCityPageUrl({
    slug,
    options,
}: {
    slug: string;
    options?: IInternalUrlOptions;
}): string {
    return internalUrl(
        `${URLs[EProjectName.BUSES]}/${slug}`,
        undefined,
        options,
    );
}
