import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {IBusesIndexQuery} from 'types/buses/index/IBusesIndexQuery';
import {IInternalUrlOptions} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

export default function getIndexUrl(params?: {
    query?: IBusesIndexQuery;
    options?: IInternalUrlOptions;
}): string {
    return internalUrl(
        URLs[EProjectName.BUSES],
        params?.query,
        params?.options,
    );
}
