import {OLD_SERVICE_HOST} from 'projects/buses/constants/url/oldService';

import appData from 'utilities/appData/appData';
import {externalUrl} from 'utilities/url';

export default function getOldServiceSearchUrl({
    fromName,
    fromId,
    toName,
    toId,
    date,
}: {
    fromName: string;
    fromId: string;
    toName: string;
    toId: string;
    date: string;
}): string {
    return externalUrl(
        `${
            OLD_SERVICE_HOST[appData.isProductionEnv ? 'PRODUCTION' : 'TESTING']
        }search`,
        {
            'from-name': fromName,
            from: fromId,
            'to-name': toName,
            to: toId,
            date,
        },
    );
}
