import {generatePath} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {IInternalUrlOptions, IUrlQuery} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

export function getBusesRouteUrl(
    fromSlug: string,
    toSlug: string,
    query?: IUrlQuery,
    options?: IInternalUrlOptions,
): string {
    return internalUrl(
        generatePath(URLs.busesSearch, {fromSlug, toSlug, sep: '--'}),
        query,
        options,
    );
}
