import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {IBusesSearchSortStore} from 'reducers/buses/types/search/IBusesSearchSortStore';
import {IBusesSearchFiltersStore} from 'reducers/buses/types/search/IBusesSearchFiltersStore';
import {
    EBusesSortDirection,
    EBusesSortType,
} from 'types/buses/search/EBusesSortType';
import {IInternalUrlOptions, IUrlQuery} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

/**
 * Возвращает поисковый урл.
 */
export default function getSearchUrl({
    fromSlug,
    toSlug,
    when,
    lastSearchTimeMarker,
    sort,
    filters,
    options,
    query,
}: {
    fromSlug?: string;
    toSlug: string;
    when?: string;
    lastSearchTimeMarker?: string;
    sort?: IBusesSearchSortStore;
    filters?: IBusesSearchFiltersStore;
    options?: IInternalUrlOptions;
    query?: IUrlQuery;
}): string {
    const preparedFilters = filters
        ? {
              ...filters,
              price: filters.price || undefined,
          }
        : {};

    return internalUrl(
        `${URLs[EProjectName.BUSES]}/${fromSlug}--${toSlug}`,
        {
            date: when,
            lastSearchTimeMarker,
            ...(sort &&
            (sort.type !== EBusesSortType.DEPARTURE ||
                sort.direction !== EBusesSortDirection.ASC)
                ? {
                      sortBy: sort.type,
                      sortDirection: sort.direction,
                  }
                : {}),
            ...preparedFilters,
            ...query,
        },
        options,
    );
}
