import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import favoritesReducer from 'reducers/favorites/reducer';

import favoritesRootSaga from 'sagas/favorites/rootSaga';

import {loadable} from 'utilities/pageLoadable';

import withSaga from 'containers/withSaga/withSaga';
import withReducers from 'containers/withReducers/withReducers';

import AppRoute from 'components/AppRoute/AppRoute';
import {FavoritesPageMeta} from './components/meta/FavoritesPageMeta';

const SharedFavoritesPage = loadable(
    () => import('./pages/SharedFavoritesPage/SharedFavoritesPage'),
);
const FavoritesPage = loadable(
    () => import('./pages/FavoritesPage/FavoritesPage'),
);
const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const FavoritesApp: React.FC = () => {
    return (
        <Switch>
            <AppRoute
                meta={FavoritesPageMeta}
                path={URLs.favoritesSharedWithToken}
                component={SharedFavoritesPage}
                exact
            />

            <AppRoute
                meta={FavoritesPageMeta}
                path={URLs.favorites}
                component={FavoritesPage}
                exact
            />

            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default withReducers([
    [ELoadableReducer.HOTELS_FAVORITES, favoritesReducer],
])(withSaga(favoritesRootSaga)(FavoritesApp));
