import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/account-Favorites';

import Modal from 'components/Modal/Modal';
import Text from 'components/Text/Text';
import Button from 'components/Button/Button';
import Flex from 'components/Flex/Flex';

import cx from './DeleteFavoriteCategoryWarningModal.scss';

export interface IDeleteFavoriteCategoryWarningModalProps
    extends IWithClassName,
        IWithDeviceType {
    isVisible: boolean;
    onClose?: () => void;
    onDelete?: () => void;
}

const DeleteFavoriteCategoryWarningModal: React.FC<IDeleteFavoriteCategoryWarningModalProps> =
    ({isVisible, onClose, deviceType, onDelete}) => {
        return (
            <Modal
                isVisible={isVisible}
                isMobile={deviceType.isMobile}
                onClose={onClose}
            >
                <Flex
                    flexDirection="column"
                    alignItems="center"
                    className={cx('root', deviceMods('root', deviceType))}
                >
                    <Text
                        size="xl"
                        weight="bold"
                        className={cx('deletion', 'text')}
                    >
                        {i18nBlock.deletion()}
                    </Text>

                    <Text size="m" className={cx('text')}>
                        {i18nBlock.areYouSure()}
                    </Text>

                    <Flex className={cx('buttons')}>
                        <Button
                            size={deviceType.isMobile ? 'l' : 'm-inset'}
                            theme="secondary"
                            className={cx('button')}
                            onClick={onDelete}
                        >
                            {i18nBlock._delete()}
                        </Button>

                        <Button
                            size={deviceType.isMobile ? 'l' : 'm-inset'}
                            theme="primary"
                            className={cx('button')}
                            onClick={onClose}
                        >
                            {i18nBlock.cancel()}
                        </Button>
                    </Flex>
                </Flex>
            </Modal>
        );
    };

export default DeleteFavoriteCategoryWarningModal;
