import React, {memo} from 'react';

import {IWithClassName} from 'types/withClassName';
import IFavoriteCategory from 'projects/favorites/types/IFavoriteCategory';

import CategoriesList from 'components/CategoriesList/CategoriesList';

import cx from './DesktopFavoriteCategories.scss';

export interface ICategory {
    key: string;
    value: string | React.ReactElement;
}

export interface IDesktopFavoriteCategoriessProps extends IWithClassName {
    onCategoryChange: (category: ICategory) => void;
    categories: IFavoriteCategory[];
    selectedCategoryId: string;
}

const DesktopFavoriteCategories: React.FC<IDesktopFavoriteCategoriessProps> = ({
    className,
    onCategoryChange,
    categories,
    selectedCategoryId,
}) => {
    const categoriesForList = categories?.map(
        ({id, name}) => ({key: id, value: name} as ICategory),
    );

    return (
        <div className={cx('root', className)}>
            <CategoriesList
                categories={categoriesForList}
                currentCategoryKey={selectedCategoryId || undefined}
                onCategoryChange={onCategoryChange}
            />
        </div>
    );
};

export default memo(DesktopFavoriteCategories);
