import React, {memo} from 'react';

import {IWithClassName} from 'types/withClassName';
import IFavoriteCategory from 'projects/favorites/types/IFavoriteCategory';

import * as favoritesKeyset from 'i18n/account-Favorites';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import CategoriesList from 'components/CategoriesList/CategoriesList';

import cx from './MobileFavoriteCategories.scss';

export interface ICategory {
    key: string;
    value: string | React.ReactElement;
}

export interface IMobileFavoriteCategoriesProps extends IWithClassName {
    onCategoryChange: (category: ICategory) => void;
    categories: IFavoriteCategory[];
    selectedCategoryId: string;
}

const MobileFavoriteCategories: React.FC<IMobileFavoriteCategoriesProps> = ({
    className,
    onCategoryChange,
    categories,
    selectedCategoryId,
}) => {
    const categoriesForList = categories?.map(({id, name, hotelCount}) => ({
        key: id,
        value: (
            <Flex className={cx('mobileCategoryItem')} flexDirection="column">
                <Text size="m" weight="bold" className={cx('name')}>
                    {name}
                </Text>

                {hotelCount && (
                    <Text size="s">
                        {favoritesKeyset.hotelsCount({count: hotelCount})}
                    </Text>
                )}
            </Flex>
        ),
    }));

    return (
        <div className={cx('root', className)}>
            <CategoriesList
                categories={categoriesForList}
                currentCategoryKey={selectedCategoryId || undefined}
                onCategoryChange={onCategoryChange}
            />
        </div>
    );
};

export default memo(MobileFavoriteCategories);
