import React from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/account-Favorites';

import Text from 'components/Text/Text';

import cx from './HotelEmptyOffer.scss';

export interface IHotelEmptyOfferProps extends IWithClassName {}

const HotelEmptyOffer: React.FC<IHotelEmptyOfferProps> = ({className}) => {
    return (
        <section className={cx(className, 'root')}>
            <Text size="m">{i18nBlock.noRooms()}</Text>
        </section>
    );
};

export default HotelEmptyOffer;
