import React from 'react';

import {MAX_HOTELS_IN_FAVORITES} from 'projects/favorites/constants';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/account-Favorites';

import Modal from 'components/Modal/Modal';
import Text from 'components/Text/Text';
import Button from 'components/Button/Button';
import Flex from 'components/Flex/Flex';

import cx from './NoMoreFavoritesModal.scss';

export interface INoMoreFavoritesModalProps extends IWithClassName {
    isVisible: boolean;
    onClose?: () => void;
}

const NoMoreFavoritesModal: React.FC<INoMoreFavoritesModalProps> = ({
    isVisible,
    onClose,
}) => {
    const deviceType = useDeviceType();

    return (
        <Modal
            isVisible={isVisible}
            isMobile={deviceType.isMobile}
            onClose={onClose}
        >
            <Flex
                flexDirection="column"
                alignItems="center"
                className={cx('root', deviceMods('root', deviceType))}
            >
                <Text
                    size="xl"
                    weight="bold"
                    className={cx('noMoreAddHotels', 'text')}
                >
                    {i18nBlock.noMoreAddHotels()}
                </Text>

                <Text size="m" className={cx('text')}>
                    {i18nBlock.noMoreAddHotelsDesciption({
                        maxNumber: MAX_HOTELS_IN_FAVORITES,
                    })}
                </Text>

                <Button
                    size={deviceType.isMobile ? 'l' : 'm-inset'}
                    theme="primary"
                    className={cx('okButton')}
                    onClick={onClose}
                    width={deviceType.isMobile ? 'max' : 'auto'}
                >
                    {i18nBlock.ok()}
                </Button>
            </Flex>
        </Modal>
    );
};

export default React.memo(NoMoreFavoritesModal);
