import React from 'react';
import {useSelector} from 'react-redux';
import {useParams} from 'react-router-dom';

import {hotelsDefaultMeta} from 'projects/hotels/constants/hotelsMeta';
import {URLs} from 'constants/urls';

import {getFavoritesInfoSelector} from 'selectors/favorites/getFavoritesInfo';

import getShareUrl from 'projects/favorites/utilities/getShareUrl';
import {getProjectUrl} from 'utilities/url';

import * as i18nFavoritesBlock from 'i18n/account-Favorites';

import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

export const FavoritesPageMeta: React.FC = () => {
    const {categories, selectedCategoryId, shareToken} = useSelector(
        getFavoritesInfoSelector,
    );

    const selectedCategoryName = categories?.find(
        category => category.id === selectedCategoryId,
    )?.name;

    const {token} = useParams<{token?: string}>();

    return (
        <SocialSharingMeta
            url={
                token || shareToken
                    ? getShareUrl(token || shareToken)
                    : `${getProjectUrl()}${URLs.favorites}`
            }
            title={
                selectedCategoryName
                    ? i18nFavoritesBlock.metaTitle({city: selectedCategoryName})
                    : hotelsDefaultMeta.title
            }
            description={hotelsDefaultMeta.description}
        />
    );
};
