import React, {useMemo} from 'react';

import {afishaUtmParams} from './constants/afishaUtmParams';

import IAfishaEventInfo from 'types/trips/IAfishaEventInfo';

import {appendQueryParams} from 'utilities/url/appendQueryParams';

import * as i18nBlock from 'i18n/happyPage';

import AfishaCard from './components/AfishaCard/AfishaCard';

import CrossSaleCardsList from '../CrossSaleCardsList/CrossSaleCardsList';

interface IAfishaProps {
    regionUrl: string;
    events: IAfishaEventInfo[];
}

const Afisha: React.FC<IAfishaProps> = ({regionUrl, events}) => {
    const url = useMemo(
        () => appendQueryParams(regionUrl, afishaUtmParams),
        [regionUrl],
    );

    if (events.length === 0) {
        return null;
    }

    return (
        <CrossSaleCardsList
            title={i18nBlock.afishaTitle()}
            subtitle={i18nBlock.afishaSubtitle()}
            linkTitle={i18nBlock.afishaLinkTitle()}
            linkUrl={url}
        >
            {events.map(event => (
                <AfishaCard key={event.eventUrl} event={event} />
            ))}
        </CrossSaleCardsList>
    );
};

export default Afisha;
