import React, {useMemo} from 'react';

import {afishaUtmParams} from '../../constants/afishaUtmParams';

import IAfishaEventInfo from 'types/trips/IAfishaEventInfo';

import {formatPrice} from 'utilities/currency';
import {CHAR_LIST_MARKER, CHAR_NBSP} from 'utilities/strings/charCodes';
import {appendQueryParams} from 'utilities/url/appendQueryParams';

import * as i18nBlock from 'i18n/happyPage';

import Text from 'components/Text/Text';
import CrossSaleCard from 'projects/happyPage/components/CrossSales/components/CrossSaleCard/CrossSaleCard';
import Flex from 'components/Flex/Flex';
import EventDate from './components/EventDate';
import TruncateText from 'components/TruncateText/TruncateText';

import cx from './AfishaCard.scss';

interface IAfishaCardProps {
    event: IAfishaEventInfo;
}

const AfishaCard: React.FC<IAfishaCardProps> = ({event}) => {
    const eventUrl = useMemo(
        () => appendQueryParams(event.eventUrl, afishaUtmParams),
        [event],
    );
    const tagsText = useMemo(
        () =>
            [
                event.minPrice
                    ? i18nBlock.afishaMinPrice({
                          price: formatPrice(event.minPrice),
                      })
                    : null,
                event.type,
                ...event.tags.filter((tag: string) => tag !== event.type),
            ].join(`${CHAR_NBSP}${CHAR_LIST_MARKER} `),
        [event],
    );

    return (
        <CrossSaleCard
            className={cx('wrapper')}
            url={eventUrl}
            imageUrl={event.imageUrl}
        >
            <Flex
                className={cx('content')}
                flexDirection="column"
                justifyContent="space-between"
            >
                <div className={cx('text')}>
                    <Text
                        size="m"
                        weight="bold"
                        tag="div"
                        className={cx('name')}
                    >
                        {event.name}
                    </Text>
                    <Text
                        size="s"
                        tag="div"
                        tagProps={{title: tagsText}}
                        className={cx('tags')}
                    >
                        <TruncateText
                            text={tagsText}
                            linesCount={2}
                            expanderText=""
                        />
                    </Text>
                </div>

                <EventDate event={event} />
            </Flex>
        </CrossSaleCard>
    );
};

export default AfishaCard;
