import React from 'react';
import moment from 'moment';

import IAfishaEventInfo from 'types/trips/IAfishaEventInfo';

import {HUMAN_DATETIME} from 'utilities/dateUtils/formats';

import CalendarIcon from 'icons/16/Calendar';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

interface IEventDateProps {
    event: IAfishaEventInfo;
}

const EventDate: React.FC<IEventDateProps> = ({event}) => {
    if (event.dateTime) {
        return (
            <TextWithIcon
                iconLeft={CalendarIcon}
                text={moment(event.dateTime).format(HUMAN_DATETIME)}
                size="s"
            />
        );
    }

    if (event.dateText) {
        return (
            <TextWithIcon
                iconLeft={CalendarIcon}
                text={event.dateText}
                size="s"
            />
        );
    }

    return null;
};

export default EventDate;
