import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Link from 'components/Link/Link';
import TravelImage from 'components/TravelImage/TravelImage';

import cx from './CrossSaleCard.scss';

interface ICrossSaleCardProps extends IWithClassName {
    imageUrl: string;
    url: string;
}

const CrossSaleCard: React.FC<ICrossSaleCardProps> = ({
    url,
    imageUrl,
    children,
    className,
}) => {
    const deviceType = useDeviceType();

    return (
        <Link
            className={cx('root', deviceMods('root', deviceType), className)}
            url={url}
            target="_blank"
        >
            <TravelImage
                className={cx('image')}
                src={imageUrl}
                hasFitCover
                isWide
                isCrop
            />

            <div className={cx('content')}>{children}</div>
        </Link>
    );
};

export default CrossSaleCard;
