import React from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Text from 'components/Text/Text';
import Box from 'components/Box/Box';
import Carousel from 'components/Carousel/Carousel';
import Link from 'components/Link/Link';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';
import Flex from 'components/Flex/Flex';

import cx from './CrossSaleCardsList.scss';

interface ICrossSaleCardsListProps {
    title: string;
    subtitle: string;
    linkUrl: string;
    linkTitle: string;
}

const CrossSaleCardsList: React.FC<ICrossSaleCardsListProps> = ({
    title,
    subtitle,
    children,
    linkUrl,
    linkTitle,
}) => {
    const deviceType = useDeviceType();

    return (
        <CardWithDeviceLayout
            className={cx('root', deviceMods('root', deviceType))}
        >
            <Text size={deviceType.isMobile ? 'l' : 'xl'} weight="bold">
                {title}
            </Text>
            <Text className={cx('subtitle')} size="s">
                {subtitle}
            </Text>

            <Box className={cx('list')} above={deviceType.isMobile ? 4 : 5}>
                {deviceType.isMobile ? (
                    <>
                        <HorizontalScroller offset={4}>
                            <Flex
                                inline
                                nowrap
                                between={3}
                                className={cx('children')}
                            >
                                {children}
                            </Flex>
                        </HorizontalScroller>
                    </>
                ) : (
                    <>
                        <Carousel
                            spaceBetween={3}
                            spaceBefore={8}
                            spaceAfter={8}
                            leftOffset={32}
                            rightOffset={32}
                            gradient
                        >
                            {children}
                        </Carousel>
                    </>
                )}
            </Box>
            {deviceType.isMobile ? (
                <ButtonLink
                    className={cx('link')}
                    url={linkUrl}
                    target="_blank"
                    size="l"
                    width="max"
                >
                    {linkTitle}
                </ButtonLink>
            ) : (
                <Link className={cx('link')} url={linkUrl} target="_blank">
                    {linkTitle}
                </Link>
            )}
        </CardWithDeviceLayout>
    );
};

export default CrossSaleCardsList;
