import {EProjectName} from 'constants/common';

import {EYtpReferer} from 'types/common/IAttribution';
import TOrderType from 'types/common/orders/TOrderType';

export default function getSearchHotelsPageYtpRefererByOrderType(
    orderType: TOrderType,
): EYtpReferer {
    switch (orderType) {
        case EProjectName.AVIA:
            return EYtpReferer.AVIA_HP_SEARCH;

        case EProjectName.TRAINS:
            return EYtpReferer.TRAINS_HP_SEARCH;

        case EProjectName.HOTELS:
            return EYtpReferer.HOTELS_HP_SEARCH;

        case EProjectName.BUSES:
            return EYtpReferer.BUSES_HP_SEARCH;
    }
}
