import React from 'react';

import IIziTravelTourInfo from 'types/trips/IIziTravelTourInfo';

import * as i18nBlock from 'i18n/happyPage';

import IziTravelTourCard from './components/IziTravelTourCard/IziTravelTourCard';

import CrossSaleCardsList from '../CrossSaleCardsList/CrossSaleCardsList';

interface IIziTravelProps {
    directUrl: string;
    tours: IIziTravelTourInfo[];
}

const IziTravel: React.FC<IIziTravelProps> = ({directUrl, tours}) => {
    return (
        <CrossSaleCardsList
            title={i18nBlock.iziTravelTitle()}
            subtitle={i18nBlock.iziTravelSubtitle()}
            linkUrl={directUrl}
            linkTitle={i18nBlock.iziTravelLinkTitle()}
        >
            {tours.map(tour => (
                <IziTravelTourCard key={tour.tourUrl} tour={tour} />
            ))}
        </CrossSaleCardsList>
    );
};

export default IziTravel;
