import React from 'react';

import IIziTravelTourInfo from 'types/trips/IIziTravelTourInfo';

import {formatDurationTime} from 'utilities/dateUtils/formatDurationTime/formatDurationTime';
import getLocalizedTourType from 'utilities/iziTravel/getLocalizedTourType';

import Text from 'components/Text/Text';
import CrossSaleCard from 'projects/happyPage/components/CrossSales/components/CrossSaleCard/CrossSaleCard';
import Flex from 'components/Flex/Flex';
import WatchIcon from 'icons/16/Watch';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './IziTravelTourCard.scss';

interface IIziTravelTourCardProps {
    tour: IIziTravelTourInfo;
}

const IziTravelTourCard: React.FC<IIziTravelTourCardProps> = ({tour}) => (
    <CrossSaleCard url={tour.tourUrl} imageUrl={tour.imageUrl}>
        <Flex
            className={cx('content')}
            flexDirection="column"
            justifyContent="space-between"
        >
            <div>
                <Text size="m" weight="bold" tag="div" className={cx('name')}>
                    {tour.name}
                </Text>
                <Text className={cx('type')} size="s">
                    {getLocalizedTourType(tour)}
                </Text>
            </div>

            {tour.duration ? (
                <TextWithIcon
                    iconLeft={WatchIcon}
                    text={formatDurationTime(tour.duration)}
                    size="s"
                />
            ) : null}
        </Flex>
    </CrossSaleCard>
);

export default IziTravelTourCard;
