import React from 'react';

import {EProjectName} from 'constants/common';

import TrainIcon from 'icons/24/Train';
import FlightIcon from 'icons/24/Flight';
import BusIcon from 'icons/24/Bus';

interface ITicketsIconProps {
    type: EProjectName;
}

const BlockIcon: React.FC<ITicketsIconProps> = ({type}) => {
    switch (type) {
        case EProjectName.TRAINS:
            return <TrainIcon />;
        case EProjectName.AVIA:
            return <FlightIcon />;
        case EProjectName.BUSES:
            return <BusIcon />;
        default:
            return null;
    }
};

export default BlockIcon;
