import {EProjectName} from 'constants/common';

import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';
import {TBlockTypes} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';
import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';

export function getMountMetricaEvent(type: TBlockTypes): TMetrikaGoal {
    switch (type) {
        case EProjectName.AVIA:
            return EHotelsGoal.HOTEL_HAPPY_PAGE_AVIA_CROSS_SALE_SHOWN;
        case EProjectName.TRAINS:
            return EHotelsGoal.HOTEL_HAPPY_PAGE_TRAINS_CROSS_SALE_SHOWN;
        case EProjectName.BUSES:
            return EHotelsGoal.HOTEL_HAPPY_PAGE_BUSES_CROSS_SALE_SHOWN;
    }

    throw new Error(`getRootUrl call error. Unknown block type "${type}"`);
}

export function getClickMetricaEvent(type: TBlockTypes): TMetrikaGoal {
    switch (type) {
        case EProjectName.AVIA:
            return EHotelsGoal.HOTEL_HAPPY_PAGE_AVIA_CROSS_SALE_CLICK;
        case EProjectName.TRAINS:
            return EHotelsGoal.HOTEL_HAPPY_PAGE_TRAINS_CROSS_SALE_CLICK;
        case EProjectName.BUSES:
            return EHotelsGoal.HOTEL_HAPPY_PAGE_BUSES_CROSS_SALE_CLICK;
    }

    throw new Error(`getRootUrl call error. Unknown block type "${type}"`);
}
