import {EProjectName} from 'constants/common';
import {URLs} from 'constants/urls';

import {EYtpReferer} from 'types/common/IAttribution';
import {
    IHappyPageCrossSaleTransportBlock,
    TBlockTypes,
} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';

import {aviaURLs} from 'projects/avia/lib/urls';
import {trainsURLs} from 'projects/trains/lib/urls';
import {busesURLs} from 'projects/buses/utilities/urls';
import {internalUrl} from 'utilities/url';
import getChildrenSeasByAges from 'projects/avia/utilities/getChildrenSeatsByAges';

export function getBlockUrl(block: IHappyPageCrossSaleTransportBlock): string {
    const {type, departureAt, from, to, adults, childrenAges} = block;

    if (!from) {
        return getRootUrl(type);
    }

    switch (type) {
        case EProjectName.AVIA:
            return aviaURLs.getSearchResultsUrl({
                fromId: from,
                toId: to,
                when: departureAt,
                adult_seats: adults,
                ytp_referer: EYtpReferer.HOTEL_HP_AVIA_SEARCH,
                ...getChildrenSeasByAges(childrenAges),
            });
        case EProjectName.TRAINS:
            return trainsURLs.getTrainsSearchUrl({
                context: {
                    from,
                    to,
                    when: departureAt,
                },
                query: {
                    ytp_referer: EYtpReferer.HOTEL_HP_TRAINS_SEARCH,
                },
            });
        case EProjectName.BUSES:
            return busesURLs.getSearchUrl({
                fromSlug: from,
                toSlug: to,
                when: departureAt,
                query: {
                    ytp_referer: EYtpReferer.HOTEL_HP_BUSES_SEARCH,
                },
            });
    }

    throw new Error(
        `getBlockUrl call error. Unknown block type "${block.type}"`,
    );
}

function getRootUrl(type: TBlockTypes): string {
    switch (type) {
        case EProjectName.AVIA:
            return internalUrl(URLs.avia, {
                ytp_referer: EYtpReferer.HOTEL_HP_AVIA_MAIN,
            });
        case EProjectName.TRAINS:
            return internalUrl(URLs.trains, {
                ytp_referer: EYtpReferer.HOTEL_HP_TRAINS_MAIN,
            });
        case EProjectName.BUSES:
            return internalUrl(URLs.buses, {
                ytp_referer: EYtpReferer.HOTEL_HP_BUSES_MAIN,
            });
    }

    throw new Error(`getRootUrl call error. Unknown block type "${type}"`);
}
