import React from 'react';

import {YANDEX_PLUS_URL} from 'constants/urls/plus';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/hotels-plusPromo2021';

import Flex from 'components/Flex/Flex';
import Card from 'components/Card/Card';
import Text from 'components/Text/Text';
import PlusBadgeM from 'icons/illustrations/PlusBadge/PlusBadgeM';
import Link from 'components/Link/Link';

import cx from './PlusBanner.scss';

interface IPlusBannerProps extends IWithClassName, IWithDeviceType {
    text: string;
}

const PlusBanner: React.FC<IPlusBannerProps> = ({
    className,
    deviceType,
    text,
}) => {
    const {isMobile} = deviceType;

    return (
        <Card
            shadow="default"
            radius={isMobile ? 'm' : 'l'}
            className={cx('root', deviceMods('root', deviceType), className)}
        >
            <Flex
                flexDirection={isMobile ? 'column-reverse' : 'row'}
                alignItems="center"
            >
                <div>
                    <Text tag="div" className={cx('plusText')}>
                        {text}
                    </Text>
                    <Link url={YANDEX_PLUS_URL} target="_blank">
                        {i18nBlock.plusInfoLink()}
                    </Link>
                </div>

                <PlusBadgeM
                    className={cx('plusIcon')}
                    width={isMobile ? 68 : 95}
                    height={isMobile ? 29 : 40}
                />
            </Flex>
        </Card>
    );
};

export default React.memo(PlusBanner);
