import {useEffect} from 'react';
import {useDispatch} from 'react-redux';

import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';

import {getHappyPageActions} from 'reducers/happyPage/actions';

export default function useRequestHappyPageInfo(
    orderId: string | undefined | null,
    orderType: EOrderApiType,
): void {
    const dispatch = useDispatch();

    useEffect(() => {
        if (!orderId) {
            throw new Error('Нет orderId');
        }

        dispatch(
            getHappyPageActions.request({
                orderId,
                orderType,
            }),
        );
    }, [dispatch, orderId, orderType]);
}
