import {
    EHappyPageCrossSaleBlock,
    IHappyPageCrossSaleHotelsBlock,
    IHappyPageCrossSalePromoBlock,
    IHappyPageCrossSaleTransportBlocks,
    THappyPageCrossSaleBlock,
} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';

export function isPromoBlock(
    block: THappyPageCrossSaleBlock,
): block is IHappyPageCrossSalePromoBlock {
    return block.blockType === EHappyPageCrossSaleBlock.PROMO;
}

export function isTransportCrossSaleBlock(
    block: THappyPageCrossSaleBlock,
): block is IHappyPageCrossSaleTransportBlocks {
    return block.blockType === EHappyPageCrossSaleBlock.TRANSPORT_CROSS_SALE;
}

export function isHotelsCrossSaleBlock(
    block: THappyPageCrossSaleBlock,
): block is IHappyPageCrossSaleHotelsBlock {
    return block.blockType === EHappyPageCrossSaleBlock.HOTEL_CROSS_SALE;
}
