import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import hotelPageReducer from 'reducers/hotels/hotelPage/reducer';

import hotelInfo from 'sagas/hotels/hotelPage/hotelInfo';
import hotelImages from 'sagas/hotels/hotelPage/hotelImages';
import hotelReviews from 'sagas/hotels/hotelPage/hotelReviews';
import hotelOffers from 'sagas/hotels/hotelPage/hotelOffers';
import similarHotels from 'sagas/hotels/hotelPage/similarHotels';
import calendarPrices from 'sagas/hotels/hotelPage/calendarPrices';
import syncHotelInfoSearchParamsWithLocation from 'sagas/hotels/hotelPage/syncHotelInfoSearchParamsWithLocation';

import {loadable} from 'utilities/pageLoadable';

import withSaga from 'containers/withSaga/withSaga';
import withReducers from 'containers/withReducers/withReducers';

const HotelPage = loadable(
    () => import('projects/hotels/pages/HotelPage/HotelPageContainer'),
);

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const HotelSearchApp: React.FC = () => {
    return (
        <Switch>
            <Route
                exact
                path={[URLs.hotelsHotelPage, URLs.hotelsHotelWithSlug]}
                component={HotelPage}
            />
            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default React.memo(
    withReducers([[ELoadableReducer.HOTELS_HOTEL_PAGE, hotelPageReducer]])(
        withSaga([
            hotelInfo,
            hotelImages,
            hotelReviews,
            hotelOffers,
            similarHotels,
            calendarPrices,
            syncHotelInfoSearchParamsWithLocation,
        ])(HotelSearchApp),
    ),
);
