import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import searchInformationReducer from 'reducers/hotels/searchInformation/reducer';
import searchSuggestsReducer from 'reducers/hotels/searchSuggests/reducer';
import previousSearchesReducer from 'reducers/hotels/previousSearches/reducer';

import {loadable} from 'utilities/pageLoadable';
import appData from 'utilities/appData/appData';

import withReducers from 'containers/withReducers/withReducers';

import AppRoute from 'components/AppRoute/AppRoute';
import GeolocationError from 'projects/hotels/components/GeolocationError/GeolocationError';

import {
    DefaultHotelDocumentMeta,
    HotelsBookMeta,
    HotelsGeoRegionMeta,
    HotelsSearchMeta,
} from 'projects/hotels/containers/Meta';

import cx from './HotelsApp.scss';

const HotelsBookApp = loadable(
    () => import('projects/hotels/applications/HotelsBookApp/HotelsBookApp'),
);

const HotelsSearchApp = loadable(
    () =>
        import('projects/hotels/applications/HotelsSearchApp/HotelsSearchApp'),
);

const HotelsGeoRegionApp = loadable(
    () =>
        import(
            'projects/hotels/applications/HotelsGeoRegionApp/HotelsGeoRegionApp'
        ),
);

const HotelSearchApp = loadable(
    () => import('projects/hotels/applications/HotelSearchApp/HotelSearchApp'),
);

const ShareImagePage = loadable(
    () => import('projects/hotels/pages/ShareImagePage/ShareImagePage'),
);

const HotelsAdsSwitch = loadable(
    () => import('projects/hotels/containers/HotelsAdsSwitch/HotelsAdsSwitch'),
);

const HotelPageMeta = loadable(
    () => import('projects/hotels/containers/Meta/HotelPageMeta'),
);

const OfferPage = loadable(
    () =>
        import('projects/hotels/pages/TravellineOfferPage/TravellineOfferPage'),
);

const OfferTestPage = loadable(
    () =>
        import(
            'projects/hotels/pages/TravellineOfferPage/TravellineOfferPageTest'
        ),
);

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const HotelsApp: React.FC = () => {
    return (
        <div className={cx('hotelsApp')}>
            <Switch>
                <Route
                    path={URLs.hotelsShareImage}
                    component={ShareImagePage}
                />
                <Route
                    path={URLs.hotelsAdsSwitch}
                    component={HotelsAdsSwitch}
                />
                {!appData.isProductionEnv && (
                    <Route
                        path={URLs.hotelsTravellineOfferTestPage}
                        component={OfferTestPage}
                    />
                )}
                <Route
                    path={URLs.hotelsTravellineOfferPage}
                    component={OfferPage}
                />
                <AppRoute
                    path={URLs.hotelsBook}
                    component={HotelsBookApp}
                    meta={HotelsBookMeta}
                />
                <AppRoute
                    path={URLs.hotelsSearch}
                    component={HotelsSearchApp}
                    meta={HotelsSearchMeta}
                />
                <AppRoute
                    path={URLs.hotelsGeoRegionPageWithFilters}
                    component={HotelsGeoRegionApp}
                    meta={HotelsGeoRegionMeta}
                />
                <AppRoute
                    path={[URLs.hotelsHotelPage, URLs.hotelsHotelWithSlug]}
                    component={HotelSearchApp}
                    meta={HotelPageMeta}
                />
                <AppRoute
                    path={URLs.hotelsGeoRegionPage}
                    component={HotelsGeoRegionApp}
                    meta={HotelsGeoRegionMeta}
                />
                <AppRoute
                    component={NotFoundApp}
                    meta={DefaultHotelDocumentMeta}
                />
            </Switch>
            <GeolocationError />
            {/* <SubscriptionPopup /> - TODO: удалить или вернуть в задаче - TRAVELFRONT-6275 */}
        </div>
    );
};

export default React.memo(
    withReducers([
        [ELoadableReducer.HOTELS_SEARCH_SUGGESTS, searchSuggestsReducer],
        [ELoadableReducer.HOTELS_SEARCH_INFORMATION, searchInformationReducer],
        [ELoadableReducer.HOTELS_PREVIOUS_SEARCHES, previousSearchesReducer],
    ])(HotelsApp),
);
