import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import geoRegionPageReducer from 'reducers/hotels/geoRegionPage/reducer';

import geoRegionInfo from 'sagas/hotels/geoRegionPage/geoRegionInfo';

import {loadable} from 'utilities/pageLoadable';

import withReducers from 'containers/withReducers/withReducers';
import withSaga from 'containers/withSaga/withSaga';

const GeoRegionPage = loadable(
    () => import('projects/hotels/pages/GeoRegionPage/GeoRegionPageContainer'),
);

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const paths = [URLs.hotelsGeoRegionPage, URLs.hotelsGeoRegionPageWithFilters];

const HotelsGeoRegionApp: React.FC = () => {
    return (
        <Switch>
            <Route exact path={paths} component={GeoRegionPage} />
            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default React.memo(
    withReducers([
        [ELoadableReducer.HOTELS_GEO_REGION_PAGE, geoRegionPageReducer],
    ])(withSaga([geoRegionInfo])(HotelsGeoRegionApp)),
);
