import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import searchPageReducer from 'reducers/hotels/searchPage/reducer';
import welcomePromocodeReducer from 'reducers/hotels/welcomePromocode/reducer';

import syncSearchParamsWithLocation from 'sagas/hotels/searchPage/syncSearchParamsWithLocation';
import searchPolling from 'sagas/hotels/searchPage/searchPolling';
import countHotels from 'sagas/hotels/searchPage/countHotels';
import selectionHandler from 'sagas/hotels/searchPage/selectionHandler';

import {loadable} from 'utilities/pageLoadable';

import withReducers from 'containers/withReducers/withReducers';
import withSaga from 'containers/withSaga/withSaga';

const SearchPage = loadable(
    () => import('projects/hotels/pages/SearchPage/SearchPageContainer'),
);

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const HotelsSearchApp: React.FC = () => {
    return (
        <Switch>
            <Route exact path={URLs.hotelsSearch} component={SearchPage} />
            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default React.memo(
    withReducers([
        [ELoadableReducer.HOTELS_SEARCH_PAGE, searchPageReducer],
        [ELoadableReducer.HOTELS_WELCOME_PROMOCODE, welcomePromocodeReducer],
    ])(
        withSaga([
            syncSearchParamsWithLocation,
            searchPolling,
            countHotels,
            selectionHandler,
        ])(HotelsSearchApp),
    ),
);
