import {FunctionComponent, ReactNode} from 'react';
import {Route, Switch, Redirect} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import legacyHotelPageReducer from 'reducers/hotels/legacyHotelPage/reducer';

import legacyHotelInfo from 'sagas/hotels/legacyHotelPage/legacyHotelInfo';

import withReducers from 'containers/withReducers/withReducers';
import withSaga from 'containers/withSaga/withSaga';

import LegacyHotelPage from 'projects/hotels/pages/LegacyHotelPage/LegacyHotelPage';

const LegacyHotelApp: FunctionComponent = () => {
    return (
        <Switch>
            <Route
                exact
                path={URLs.legacyHotelPage}
                component={LegacyHotelPage}
            />
            <Route
                path={URLs.hotel}
                render={(): ReactNode => <Redirect to={URLs.notFound} />}
            />
        </Switch>
    );
};

export default withReducers([
    [ELoadableReducer.HOTELS_LEGACY_HOTEL_PAGE, legacyHotelPageReducer],
])(withSaga([legacyHotelInfo])(LegacyHotelApp));
