import {
    IHotelAmenitiesGroup,
    IHotelOrRoomAmenity,
} from 'types/hotels/hotel/IHotel';
import {IWithDeviceType} from 'types/withDeviceType';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import AdditionalAmenitiesBlock from './components/AdditionalAmenitiesBlock/AdditionalAmenitiesBlock';
import AmenitiesLayout from './components/AmenitiesLayout/AmenitiesLayout';
import MainAmenities from './components/MainAmenities/MainAmenities';

interface IGroupedAmenitiesProps extends IWithDeviceType, IWithQaAttributes {
    mainAmenities?: IHotelOrRoomAmenity[];
    isAllAmenities: boolean;
    isModal?: boolean;
    amenityGroups?: IHotelAmenitiesGroup[];
}

const Amenities: React.FC<IGroupedAmenitiesProps> = ({
    mainAmenities,
    amenityGroups,
    deviceType,
    isAllAmenities,
}) => {
    if (!mainAmenities?.length) {
        return null;
    }

    return (
        <AmenitiesLayout deviceType={deviceType}>
            <MainAmenities
                mainAmenities={mainAmenities}
                isAllAmenities={isAllAmenities}
                deviceType={deviceType}
            />
            {amenityGroups && (
                <AdditionalAmenitiesBlock
                    amenityGroups={amenityGroups}
                    isAllAmenities={isAllAmenities}
                    deviceType={deviceType}
                />
            )}
        </AmenitiesLayout>
    );
};

export default Amenities;
