import {IWithDeviceType} from 'types/withDeviceType';
import {IHotelAmenitiesGroup} from 'types/hotels/hotel/IHotel';

import {deviceMods} from 'utilities/stylesUtils';

import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';
import AmenityGroup from 'projects/hotels/components/Amenities/components/AmenityGroup/AmenityGroup';

import cx from './AdditionalAmenitiesBlock.scss';

interface IAdditionalAmenitiesBlockProps extends IWithDeviceType {
    isAllAmenities: boolean;
    isModal?: boolean;
    amenityGroups: IHotelAmenitiesGroup[];
}

const AdditionalAmenitiesBlock: React.FC<IAdditionalAmenitiesBlockProps> = ({
    amenityGroups,
    isAllAmenities,
    deviceType,
}) => {
    return (
        <AutoHeightAnimateControl canShowComponent={isAllAmenities}>
            <div
                className={cx(
                    'additionalAmenities',
                    deviceMods('additionalAmenities', deviceType),
                )}
            >
                {amenityGroups.map(group => (
                    <AmenityGroup
                        className={cx(
                            'amenityGroup',
                            deviceMods('amenityGroup', deviceType),
                        )}
                        key={group.id}
                        amenityGroup={group}
                        deviceType={deviceType}
                    />
                ))}
            </div>
        </AutoHeightAnimateControl>
    );
};

export default AdditionalAmenitiesBlock;
